#if !defined(VIEWMOL_MATH)
#define VIEWMOL_MATH

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define strnicmp strncasecmp

#define sqr(a)  ((a)*(a))
#define at(a,x) atoms[bonds[i].a-1].x
#define len(x,y,z,xx,yy,zz) sqrt(sqr(x-xx)+sqr(y-yy)+sqr(z-zz))
#define x1 at(a,x)
#define x2 at(b,x)
#define y1 at(a,y)
#define y2 at(b,y)
#define z1 at(a,z)
#define z2 at(b,z)

#define PI (3.14159265358979323846)
#define ver 3.71
#define MAXsl 67
#define inca 5
#define radTheta 0.1
#define MAXSELECT 2560
        // max selected at once. four elements per object
#define vt 7

        // all the global
struct atom { int type; GLdouble x,y,z,c;};
struct bond { int a,b;  GLdouble o;};
struct freq { int img;  GLdouble freqv,inten,x[32],y[32],z[32];};

extern GLdouble sinez[MAXsl];
extern GLdouble cosez[MAXsl];
extern GLint	OBJslices;

extern int NumAtoms, NumBonds, NumOrb,
    trad, bond, persp, wire, dline, chg, present, debug, morb,
    monum, atnum, spread, freqss, viewir, frcur;

extern double BondTresh,MulPop[256][256];

extern struct  atom atoms[512];
extern struct  bond bonds[1024];
extern struct  freq freqs[3*32];

extern GLfloat  bondmat[];
extern GLfloat  irmat[];
extern GLdouble ax, ay, az, maxcor;
extern GLint    at_level, bn_level;
extern GLint    windW, windH;
extern GLint    windX, windY;
extern GLint    ap1,ap2,ap3,ap4;

extern GLuint selectBuf[MAXSELECT];
extern GLint   vp[4];

extern char    fname[256];

extern GLfloat mat_ambient1[], mat_specular1[], light_position1[],
        light_position2[], lm_ambient1[], light_color1[], light_color2[];

        // Define Atoms Colors
extern GLfloat at_def[18][4];

extern GLfloat PosChg[4];
extern GLfloat NegChg[4];
extern GLfloat MulPopMat[4];
extern GLfloat White[4];
extern GLfloat at_rad[18];
extern GLfloat at_radv[18];
extern GLfloat roma[4][4];
extern GLfloat romb[4][4];

#endif
